import strawberry

import hircine.api.responses as rp
import hircine.db.models as models
from hircine.api.types import (
    Archive,
    Artist,
    Character,
    Circle,
    Comic,
    ComicScraper,
    ComicTag,
    FilterResult,
    Namespace,
    Tag,
    World,
)

from .resolvers import (
    comic_scrapers,
    comic_tags,
    every,
    scrape_comic,
    single,
    statistics,
)


def query(resolver):
    return strawberry.field(resolver=resolver)


@strawberry.type
class Query:
    archive: rp.ArchiveResponse = query(single(models.Archive, full=True))
    archives: FilterResult[Archive] = query(every(models.Archive))
    artist: rp.ArtistResponse = query(single(models.Artist))
    artists: FilterResult[Artist] = query(every(models.Artist))
    character: rp.CharacterResponse = query(single(models.Character))
    characters: FilterResult[Character] = query(every(models.Character))
    circle: rp.CircleResponse = query(single(models.Circle))
    circles: FilterResult[Circle] = query(every(models.Circle))
    comic: rp.ComicResponse = query(single(models.Comic, full=True))
    comic_scrapers: list[ComicScraper] = query(comic_scrapers)
    comic_tags: FilterResult[ComicTag] = query(comic_tags)
    comics: FilterResult[Comic] = query(every(models.Comic))
    namespace: rp.NamespaceResponse = query(single(models.Namespace))
    namespaces: FilterResult[Namespace] = query(every(models.Namespace))
    tag: rp.TagResponse = query(single(models.Tag, full=True))
    tags: FilterResult[Tag] = query(every(models.Tag))
    world: rp.WorldResponse = query(single(models.World))
    worlds: FilterResult[World] = query(every(models.World))
    scrape_comic: rp.ScrapeComicResponse = query(scrape_comic)
    statistics: rp.Statistics = query(statistics)
