import enum
from typing import Generic, Optional, TypeVar

import sqlalchemy
import strawberry

import hircine.db.models as models

T = TypeVar("T")


@strawberry.enum
class SortDirection(enum.Enum):
    ASCENDING = strawberry.enum_value(sqlalchemy.asc)
    DESCENDING = strawberry.enum_value(sqlalchemy.desc)


@strawberry.enum
class ComicSort(enum.Enum):
    TITLE = strawberry.enum_value(models.Comic.title)
    ORIGINAL_TITLE = strawberry.enum_value(models.Comic.original_title)
    DATE = strawberry.enum_value(models.Comic.date)
    CREATED_AT = strawberry.enum_value(models.Comic.created_at)
    UPDATED_AT = strawberry.enum_value(models.Comic.updated_at)
    ARTIST_COUNT = strawberry.enum_value(models.Comic.artist_count)
    CHARACTER_COUNT = strawberry.enum_value(models.Comic.character_count)
    CIRCLE_COUNT = strawberry.enum_value(models.Comic.circle_count)
    WORLD_COUNT = strawberry.enum_value(models.Comic.world_count)
    TAG_COUNT = strawberry.enum_value(models.Comic.tag_count)
    PAGE_COUNT = strawberry.enum_value(models.Comic.page_count)
    RANDOM = "Random"


@strawberry.enum
class ArchiveSort(enum.Enum):
    PATH = strawberry.enum_value(models.Archive.path)
    SIZE = strawberry.enum_value(models.Archive.size)
    CREATED_AT = strawberry.enum_value(models.Archive.created_at)
    PAGE_COUNT = strawberry.enum_value(models.Archive.page_count)
    RANDOM = "Random"


@strawberry.enum
class ArtistSort(enum.Enum):
    NAME = strawberry.enum_value(models.Artist.name)
    CREATED_AT = strawberry.enum_value(models.Artist.created_at)
    UPDATED_AT = strawberry.enum_value(models.Artist.updated_at)
    COMIC_COUNT = strawberry.enum_value(models.Artist.comic_count)
    RANDOM = "Random"


@strawberry.enum
class CharacterSort(enum.Enum):
    NAME = strawberry.enum_value(models.Character.name)
    CREATED_AT = strawberry.enum_value(models.Character.created_at)
    UPDATED_AT = strawberry.enum_value(models.Character.updated_at)
    COMIC_COUNT = strawberry.enum_value(models.Character.comic_count)
    RANDOM = "Random"


@strawberry.enum
class CircleSort(enum.Enum):
    NAME = strawberry.enum_value(models.Circle.name)
    CREATED_AT = strawberry.enum_value(models.Circle.created_at)
    UPDATED_AT = strawberry.enum_value(models.Circle.updated_at)
    COMIC_COUNT = strawberry.enum_value(models.Circle.comic_count)
    RANDOM = "Random"


@strawberry.enum
class NamespaceSort(enum.Enum):
    SORT_NAME = strawberry.enum_value(models.Namespace.sort_name)
    NAME = strawberry.enum_value(models.Namespace.name)
    CREATED_AT = strawberry.enum_value(models.Namespace.created_at)
    UPDATED_AT = strawberry.enum_value(models.Namespace.updated_at)
    TAG_COUNT = strawberry.enum_value(models.Namespace.tag_count)
    RANDOM = "Random"


@strawberry.enum
class TagSort(enum.Enum):
    NAME = strawberry.enum_value(models.Tag.name)
    CREATED_AT = strawberry.enum_value(models.Tag.created_at)
    UPDATED_AT = strawberry.enum_value(models.Tag.updated_at)
    COMIC_COUNT = strawberry.enum_value(models.Tag.comic_count)
    NAMESPACE_COUNT = strawberry.enum_value(models.Tag.namespace_count)
    RANDOM = "Random"


@strawberry.enum
class WorldSort(enum.Enum):
    NAME = strawberry.enum_value(models.World.name)
    CREATED_AT = strawberry.enum_value(models.World.created_at)
    UPDATED_AT = strawberry.enum_value(models.World.updated_at)
    COMIC_COUNT = strawberry.enum_value(models.World.comic_count)
    RANDOM = "Random"


# Use a generic "Input" name so that we end up with sane GraphQL type names
# See also: filter.py
@strawberry.input
class Input(Generic[T]):
    on: T
    direction: Optional[SortDirection] = SortDirection.ASCENDING
    seed: Optional[int] = strawberry.UNSET
