class APIException(Exception):
    def __init__(self, graphql_error):
        self.graphql_error = graphql_error


class MutationContext:
    """
    Relevant information and data for mutations as they are being resolved.

    Attributes:
        input: The strawberry input object for the mutation
        root: The root object being modified by the mutation
        session: The active SQLAlchemy session
        model: The SQLAlchemy modelclass of the object being modified by the mutation
        multiple: True if multiple objects in the database are being modified
    """

    def __init__(self, input, root, session, multiple=False):
        self.session = session
        self.input = input
        self.root = root
        self.model = type(root)
        self.multiple = multiple
