from importlib.metadata import entry_points

from hircine.scraper import Scraper

scraper_registry: dict[str, type[Scraper]] = {}
transformers = []


def get_scraper(name):
    return scraper_registry.get(name)


def get_scrapers():
    return scraper_registry.items()


def register_scraper(name, cls):
    scraper_registry[name] = cls


def transformer(function):
    """
    Marks the decorated function as a transformer.

    The decorated function must be a generator function that yields
    :ref:`scraped-data`. The following parameters will be available to the
    decorated function:

    :param generator: The scraper's generator function.
    :param ScraperInfo info: Information on the scraper.
    """

    def _decorate(function):
        transformers.append(function)
        return function

    return _decorate(function)


def load():  # pragma: no cover
    for entry in entry_points(group="hircine.scraper"):
        register_scraper(entry.name, entry.load())

    for entry in entry_points(group="hircine.transformer"):
        entry.load()


load()
