from hircine.scraper.types import (
    URL,
    Artist,
    Circle,
    Date,
    Language,
    Tag,
    Title,
)
from hircine.scraper.utils import parse_dict


class MangadexHandler:
    source = "mangadex"

    def scrape(self, data):
        parsers = {
            "date": Date.from_iso,
            "lang": Language.from_iso_639_3,
            "tags": Tag.from_string,
            "artist": Artist,
            "author": Artist,
            "group": Circle,
        }

        yield from parse_dict(parsers, data)

        if chapter_id := data.get("chapter_id"):
            yield URL(f"https://mangadex.org/chapter/{chapter_id}")

        if manga := data.get("manga"):
            title = manga

            if volume := data.get("volume"):
                title = title + f" Vol. {volume}"

            if chapter := data.get("chapter"):
                if volume:
                    title = title + f", Ch. {chapter}"
                else:
                    title = title + f" Ch. {chapter}"

            if subtitle := data.get("title"):
                title = title + f": {subtitle}"

            yield Title(title)
