import strawberry

from hircine.api.responses import (
    AddComicResponse,
    AddResponse,
    DeleteResponse,
    MergeComicResponse,
    UpdateResponse,
    UpsertResponse,
)
from hircine.db.models import (
    Archive,
    Artist,
    Character,
    Circle,
    Comic,
    Namespace,
    Tag,
    World,
)

from .resolvers import (
    add,
    delete,
    merge_comics,
    post_add_comic,
    post_delete_archive,
    update,
    upsert,
)


def mutate(resolver):
    return strawberry.mutation(resolver=resolver)


@strawberry.type
class Mutation:
    update_archives: UpdateResponse = mutate(update(Archive))
    delete_archives: DeleteResponse = mutate(
        delete(Archive, post_delete=post_delete_archive)
    )

    add_comic: AddComicResponse = mutate(add(Comic, post_add=post_add_comic))
    delete_comics: DeleteResponse = mutate(delete(Comic))
    update_comics: UpdateResponse = mutate(update(Comic))
    upsert_comics: UpsertResponse = mutate(upsert(Comic))
    merge_comics: MergeComicResponse = mutate(merge_comics)

    add_namespace: AddResponse = mutate(add(Namespace))
    delete_namespaces: DeleteResponse = mutate(delete(Namespace))
    update_namespaces: UpdateResponse = mutate(update(Namespace))

    add_tag: AddResponse = mutate(add(Tag))
    delete_tags: DeleteResponse = mutate(delete(Tag))
    update_tags: UpdateResponse = mutate(update(Tag))

    add_circle: AddResponse = mutate(add(Circle))
    delete_circles: DeleteResponse = mutate(delete(Circle))
    update_circles: UpdateResponse = mutate(update(Circle))

    add_artist: AddResponse = mutate(add(Artist))
    delete_artists: DeleteResponse = mutate(delete(Artist))
    update_artists: UpdateResponse = mutate(update(Artist))

    add_character: AddResponse = mutate(add(Character))
    delete_characters: DeleteResponse = mutate(delete(Character))
    update_characters: UpdateResponse = mutate(update(Character))

    add_world: AddResponse = mutate(add(World))
    delete_worlds: DeleteResponse = mutate(delete(World))
    update_worlds: UpdateResponse = mutate(update(World))
