import os

dir_structure = None


class DirectoryStructure:
    def __init__(
        self,
        database="hircine.db",
        scan="content/",
        objects="objects/",
        backups="backups/",
        config="hircine.ini",
    ):
        self.database = database
        self.scan = scan
        self.objects = objects
        self.backups = backups
        self.config = config

    def mkdirs(self):  # pragma: no cover
        os.makedirs(self.objects, exist_ok=True)
        os.makedirs(self.scan, exist_ok=True)
        os.makedirs(self.backups, exist_ok=True)


def init_dir_structure():  # pragma: no cover
    global dir_structure

    dir_structure = DirectoryStructure()

    return dir_structure


def get_dir_structure():
    global dir_structure

    return dir_structure
