from hircine.scraper.types import (
    Artist,
    Circle,
    Date,
    Language,
    Title,
)
from hircine.scraper.utils import parse_dict


class DynastyScansHandler:
    source = "dynastyscans"

    def scrape(self, data):
        parsers = {
            "date": Date.from_iso,
            "lang": Language.from_iso_639_3,
            "author": Artist,
            "group": Circle,
        }

        yield from parse_dict(parsers, data)

        if manga := data.get("manga"):
            title = manga

            if chapter := data.get("chapter"):
                title = title + f" Ch. {chapter}"

            if subtitle := data.get("title"):
                title = title + f": {subtitle}"

            yield Title(title)
